<?php
/* --------------------------------------------------------------
  Repository.php 2020-02-24
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitEan\Repository;

use Gambio\Shop\Attributes\SellingUnitEan\Repository\Dto\EanCollectionDto;
use Gambio\Shop\Attributes\SellingUnitEan\Repository\Dto\EanDto;
use Gambio\Shop\Attributes\SellingUnitEan\Repository\Reader\ReaderInterface;
use Gambio\Shop\Product\ValueObjects\ProductId;

/**
 * Class Repository
 * @package Gambio\Shop\Attributes\SellingUnitEan\Repository
 */
class Repository implements RepositoryInterface
{
    /**
     * @var ReaderInterface
     */
    protected $reader;
    
    
    /**
     * Repository constructor.
     *
     * @param ReaderInterface $reader
     */
    public function __construct(ReaderInterface $reader)
    {
        $this->reader = $reader;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getEanValuesByProduct(array $optionIds, ProductId $productId) : EanCollectionDto
    {
        $collection = [];
        $eanValues  = $this->reader->getEanValuesByProductId($optionIds, $productId->value());
        foreach ($eanValues as $eanValue) {
            $collection[] = new EanDto($eanValue);
        }
        
        return new EanCollectionDto($collection);
    }
    
}